#!/bin/bash
#SBATCH --job-name=compbench_coco_prompts_generation
#SBATCH --nodes=1
#SBATCH --gres=gpu:rtxa6000:1
#SBATCH --cpus-per-task=4
#SBATCH --mem=32G
#SBATCH --partition=scavenger
#SBATCH --account=scavenger
#SBATCH --time=24:00:00

# Command to run this:   for i in {0..19}; do sbatch --output="/cmlscratch/XXX/t5_analysis/final_experiments/fid_score/compbench/logs/slurm-logs-$i/out.log" --error="/cmlscratch/XXX/t5_analysis/final_experiments/fid_score/compbench/logs/slurm-logs-$i/err.log" --export=chunk_idx=$i compbench_coco_prompts_generation.sh; done

cd /cmlscratch/XXX/t5_analysis/T2I-CompBench

source .venv/bin/activate

cd /cmlscratch/XXX/t5_analysis/T2I-CompBench/GORS_finetune

python coco_prompts_generation.py --pretrained_model_path "checkpoint/color/lora_weight_e357_s124500.pt" --path_to_save_generated_images "/cmlscratch/XXX/t5_analysis/final_experiments/fid_score/compbench" --chunk_idx=$chunk_idx

