# InjecMEM - Quick Start

This README explains how to start the local services, and how to run the codes.

## 1. Launch the vLLM api server

```bash
python -m vllm.entrypoints.openai.api_server \
--model your_model_path \
--max_model_len 8000 \
--port 8000 \
--max-num-seqs 5 \
--served-model-name Qwen/Qwen2.5-7B-Instruct
```
---

## 2. Launch the Sentence Transformer service

```bash
cd InjecMEM
python ./MemorySystem/memoryos/sentrans.py
```

Keep this process running. It exposes the embedding endpoint used by the memory system.

---

## 3. Preset memory system, inject poisoned interaction, and test on continous queries

First, we preset the memory system store by injecting numerous conversations across all domains. This is step 0, and benign_total means the total number of conversations injected to memory store.
```bash
python ./MemorySystem/memoryos/inject_generate.py \
--memorypath ./MemorySystem/memoryos/memory_base/run_1 \
--steps 0 --benign_total 60 --seed 20
```

Then, we inject the crafted prompts by interact once with agent. And domain means the attack targeted domain topic.
```bash
python ./MemorySystem/memoryos/inject_generate.py \
--memorypath ./MemorySystem/memoryos/memory_base/run_1 \
--steps 1 --domain health
```

For test, we interact with the agent using queries about the target domain. n_eval means the total number os eval data. Between two queries on the target topic, we randomly inject noise_max conversations sampled from other domains.
```bash
python ./MemorySystem/memoryos/inject_generate.py \
--memorypath ./MemorySystem/memoryos/memory_base/run_1 \
--steps 2 --domain health --n_eval 10 --noise_max 3 --seed 26
```

Or, you can just simply run 
```bash
sh ./MemorySystem/memoryos/simple_run.sh
```
---