import wandb
from experiments.Automaton import LifeLikeAutomaton2D,CoarseWrapper
from experiments.Trainer import Trainer
# Authenticate (ensure you're logged in)
api = wandb.Api()

# Replace with your entity and project name
entity = # e.g., "my-username" or your org
cache_folder = #cache folder


for project in ["CA_test_onlyTime","CA_test_onlyTime_noNat",
                "CA_test_spaceAndTime_noNat", "CA_test_timeCG_centerStrong_noNat",
                "CA_test_timeCG_centerStrong32_noNat"]:


    # Fetch all runs
    runs = api.runs(f"{entity}/{project}")


    keysConf = (runs[0].config.keys())
    keysSum = (runs[0].summary.keys())

    keys = list(set(keysConf).union(set(keysSum)))


    import pandas as pd

    rows = []

    for run in runs:
        
        config = run.config
        summary = run.summary
        run_dict = {}
        for key,value in config.items():
            run_dict[key] = value
        for key,value in summary.items():
            run_dict[key] = value
        
        #add the run_dict to the dataframe
        rows.append(run_dict)
    # Create a DataFrame from the list of dictionaries
    df = pd.DataFrame(rows)


    df.head()

    df.to_csv(f"{cache_folder}/{project}.csv", index=False)

