
import torch
from experiments.Networks import CA_CNN_Convolutional
from experiments.Automaton import CoarseWrapper, LifeLikeAutomaton2D, CellularAutomaton2D, create_init_only_center
from experiments.Trainer import Trainer, DataLogger, SGDTrainer

"""
Experiments for Spatial CG with Naturalization
"""
if __name__=="__main__":
    
    
    for i in range(512-(810)//9):
        import random
        num = random.randint(0, 2**18)
        for iters in [3,4,5]:
            for spatial_factor in [3,5,7]:
                grid_size=16
                CA = LifeLikeAutomaton2D(num,grid_size)
                spatial_factor=spatial_factor
                coarse = CoarseWrapper(CA, iters, spatial_factor, only_output_coarse=True, init_function=None)
                
                for residual in [False]:
                    for extra_width in [1]:
                        for train_length in [3]:

                            net_iters = iters + spatial_factor//2

                            net = CA_CNN_Convolutional(64*(2**extra_width), net_iters, num_classes=2, extra_depth=2, residual=residual,use_bn=True, device='cuda')


                            data_logger = DataLogger(use_wandb=True, use_local=True, localPath='results/', 
                                                    localName='Rule'+str(num), console=False, 
                                                    wandbProject="CA_test_spaceAndTime_Nat",wandbRunName="RuleLong"+str(num))
                            trainer = Trainer(net, coarse, data_logger)
                            try:
                                trainer.train(512*(2**train_length), 32, 1e-4, early_stopping=0.98, nat_its=12)
                            except:
                                print("Error in training, skipping rule", num)
                                
                            del net
                            del data_logger
                            del trainer

        print("Finished rule", num)
        print("Iteration ", i)
   