import json

def calculate_matching_proportion(file_path, total_records=0):
    # Load the JSON file
    with open(file_path, 'r', encoding='utf-8') as file:
        records = json.load(file)
    
    # Initialize counters
    matching_70B = 0
    matching_rm = 0
    processed_records = 0
    
    # Iterate through each record, respecting the total_records limit if specified
    for record in records:
        if total_records and processed_records >= total_records:
            break
        
        processed_records += 1
        
        # Check if '70B_rank_order' matches 'rank_order'
        if record.get("70B_rank_order") == record.get("rank_order"):
            matching_70B += 1
        
        # Check if 'rm_order' matches 'rank_order'
        if record.get("rm_order") == record.get("rank_order"):
            matching_rm += 1
    
    # Calculate the matching proportions
    if processed_records == 0:
        print("No records found.")
        return {"70B_proportion": 0, "rm_proportion": 0}, 0
    
    matching_70B_proportion = matching_70B / processed_records
    matching_rm_proportion = matching_rm / processed_records
    
    return {
        "70B_proportion": matching_70B_proportion,
        "rm_proportion": matching_rm_proportion
    }, processed_records

# Path to the JSON file
file_path = "/scratch/avt2gy/persona-hub/output/Meta-Llama-3-8B-Instruct/score/rm_score_vllm_instruction_synthesis_response_copy.jsonl"

# Calculate and print the matching proportion
matching_proportions, processed_records = calculate_matching_proportion(file_path, total_records=60000)
print(f"Proportion of matching '70B_rank_order' and 'rank_order': {matching_proportions['70B_proportion']:.2%}")
print(f"Proportion of matching 'rm_order' and 'rank_order': {matching_proportions['rm_proportion']:.2%}")
print(f"TOTAL: {processed_records}")
