from abc import abstractmethod

from ai_control_games.generic_game import Game, RedTeamStrategy, BlueTeamPolicy
from ai_control_games.generic_optimisation import FrontierExplorerWithIterativeDeterministicEquilibriumFinding, \
    SingleObjectiveOptimiserOutput, FrontierExplorerWithIterativeMixedEquilibriumFinding, FrontierExplorerWithDoubleOracle
from ai_control_games.trusted_monitor.optimization.abstract_explorer import TMFrontierExplorer


class TMFrontierExplorerIteratedDet(TMFrontierExplorer, FrontierExplorerWithIterativeDeterministicEquilibriumFinding):
    def __init__(self, *args, **kwargs):
        TMFrontierExplorer.__init__(self, *args, **kwargs)
        FrontierExplorerWithIterativeDeterministicEquilibriumFinding.__init__(self)

    def get_single_obj_equilibrium(self, game: Game, weight: float) -> SingleObjectiveOptimiserOutput:
        f = FrontierExplorerWithIterativeDeterministicEquilibriumFinding.get_single_obj_equilibrium
        return f(self, game, weight)

    @abstractmethod
    def get_value_and_blue_best_response(self, game: Game, weight: float, red_pol: RedTeamStrategy) \
            -> tuple[float, BlueTeamPolicy]:
        pass


class TMFrontierExplorerIteratedMixed(TMFrontierExplorer, FrontierExplorerWithIterativeMixedEquilibriumFinding):
    def __init__(self, *args, **kwargs):
        TMFrontierExplorer.__init__(self, *args, **kwargs)
        FrontierExplorerWithIterativeMixedEquilibriumFinding.__init__(self)

    def get_single_obj_equilibrium(self, game: Game, weight: float) -> SingleObjectiveOptimiserOutput:
        f = FrontierExplorerWithIterativeMixedEquilibriumFinding.get_single_obj_equilibrium
        return f(self, game, weight)

    @abstractmethod
    def get_value_and_blue_best_response(self, game: Game, weight: float, red_pol: RedTeamStrategy) \
            -> tuple[float, BlueTeamPolicy]:
        pass

class TMFrontierExplorerDoubleOracle(TMFrontierExplorer, FrontierExplorerWithDoubleOracle):
    def __init__(self, *args, **kwargs):
        TMFrontierExplorer.__init__(self, *args, **kwargs)
        FrontierExplorerWithDoubleOracle.__init__(self, *args, **kwargs)
    
    def get_single_obj_equilibrium(self, game: Game, weight: float) -> SingleObjectiveOptimiserOutput:
        f = FrontierExplorerWithDoubleOracle.get_single_obj_equilibrium
        return f(self, game, weight)

    @abstractmethod
    def get_value_and_blue_best_response(self, game: Game, weight: float, red_pol: RedTeamStrategy) \
            -> tuple[float, float, BlueTeamPolicy]:
        pass
