"""
This code is originally from https://github.com/NVlabs/SPADE
Licensed under the CC BY-NC-SA 4.0 license (https://creativecommons.org/licenses/by-nc-sa/4.0/legalcode).
"""

from .base_options import BaseOptions


class TestOptions(BaseOptions):
    def initialize(self, parser):
        BaseOptions.initialize(self, parser)
        parser.add_argument('--results_dir', type=str, default='./results/', help='saves results here.')
        parser.add_argument('--which_epoch', type=int, default=30, help='which epoch to load? set to latest to use latest cached model')
        parser.add_argument('--how_many', type=int, default=float("inf"), help='how many test images to run')

        parser.add_argument('--start_idx', type=int, default=0, help='start index of recursive trajectory generation')
        parser.add_argument('--seq_len', type=int, default=5, help='the length of the sequence')

        parser.set_defaults(preprocess_mode='scale_width_and_crop', crop_size=128, load_size=128, display_winsize=128)
        parser.set_defaults(serial_batches=True)
        parser.set_defaults(phase='test')
        self.isTrain = False
        return parser
