# 1 Mistake in official code of HidePrompt

An error occurred while tensor reshaping. Specifically, at lines 107-111 and lines 115-118 of `./HiDe-Prompt-main_before_modified_official_code/peft/prompt/hide_prompt.py` and at lines 128-131 and lines 134-137 of `./HiDe-Prompt-main_before_modified_official_code/peft/prompt/dp_prompt.py`.

Specifically:

## Step 1

From lines 39 to 45 in `./HiDe-Prompt-main_before_modified_official_code/peft/prompt/hide_prompt.py`:

`self.prompt` is a tensor with shape `num_layers, 2, pool_size, length, num_heads, embed_dim // num_heads`, where `num_layers` indicates the layer of the `vision transformer` where the prompt is to be inserted. HidePrompt will prepend a set of prompts to the input for the first five layers. `2` indicates that `prefix tuning` is used, which prepends a set of prompts on both the `K_value` and the `V_value` in `attention mechanism` (for details, please refer to DualPrompt: Complementary Prompting for Rehearsal-free Continual Learning, ECCV, 2022).
`pool_size` indicates the number of prompts sets. Current Prompt-Based Continual Methods add a set of prompts for each task, initializing all at the beginning for convenience. Therefore, `pool_size` is the same as the number of incremental tasks.

The remaining parameters are not important for analyzing the error, so they are briefly skipped here.

## Step 2

From line 109 in `./HiDe-Prompt-main_before_modified_official_code/peft/prompt/hide_prompt.py`:

`batched_prompt_raw` is a tensor with shape `num_layers, dual, batch_size, top_k, length, num_heads, heads_embed_dim`, where `dual` indicates that this is `prefix tuning`, so it is `2`. The rest of the parameters have the same meaning as in step 1.

From line 110 in `./HiDe-Prompt-main_before_modified_official_code/peft/prompt/hide_prompt.py`, we want `batched_prompt` to correspond to each input so that we can prepend it to `K_value` and `V_value` using `prefix tuning`. However, directly `reshaping` will cause confusion, mixing the prompts set to be inserted into `K_value` and `V_value` of the first sample with those of the second sample.

We should use `permute` to swap the dimensions before `reshaping`.

Therefore, this is an issue of tensor dimension transformation, occurring at lines 110 and 117 in `./HiDe-Prompt-main_before_modified_official_code/peft/prompt/hide_prompt.py`. We have checked the currently available open-source codes and found same issues in the subsequent works based on the code from \url{https://github.com/JH-LEE-KR/dualprompt-pytorch}.

We mentioned this mistake in the README rather than in the main paper because it is a minor error. However, this does impact the community, as analyzed above. An uncorrected error makes it likely that the set of prompts retrieved for sample a is incorrect. Furthermore, after we corrected the error, we found that many results showed significant performance degradation.



# 2 Comparison of Results Before and After Modification


Results before modification can be reproduced as follows:

In the `./HiDe-Prompt-main_before_modified_official_code` directory

`bash training_scripts/train_cifar100_vit.sh`

Results after modification can be reproduced as follows:

In the `./HiDe-Prompt-main_after_modified` directory

`bash training_scripts/train_cifar100_vit.sh`

Results on other benchmarks can be reproduced by invoking the corresponding bash scripts in the same way as described above.







