import argparse
import numpy as np
from torch import nn, optim
import sys
import os

class Arguments(argparse.Namespace):
	dataset = 'PACS'
	source = ['art_painting', 'cartoon', 'sketch', 'photo']
	target = 'art_painting'
	n_classes = 7
	
	# data augmentation configs#########
	image_size = 224 # 256 for AlexNet
	####################################

	# Hyper-parameters #################
	epochs = 100
	batch_size = 64
	learning_rate = 0.01
	mask_learning_rate = 1
	nesterov = False

	sigmoid_head = False
	network = 'ResNet50'
	feature_dim = 512
	partition = 256
	####################################
	
	runs = 1
	
	####################################
	tf_logger = True
	folder_name = 'test'
	suffix = ''
	log_file = 'logs'

	#random_seed = 2020
	

	def __init__(self):
		super().__init__()


def parse_args(args: Arguments, cmd_args=None):
	parser = argparse.ArgumentParser(usage='python %(prog)s [options]')
	attributes = {}
	attributes.update(Arguments.__dict__)
	for attribute, default_value in attributes.items():
		if attribute[0] != '_':
			parser.add_argument(f'--{attribute}', type=type(default_value), default=default_value, metavar='',
								help="default: %(default)s")
	parser.parse_args(args=cmd_args, namespace=args)

args = Arguments()
