import numpy as np
import sys
import argparse



main_arg_parser = argparse.ArgumentParser(description="parser")

main_arg_parser.add_argument("--name", type=str, default='', help='')
args = main_arg_parser.parse_args()


data = np.load(args.name)
print(data['T'])
print(data['Y'])
n = data['T'].shape[0]
print('running experiments multiple times: {}'.format(n))

print('Last epoch results:\n')

tau = [-1.0, 0.4, 0.5, 0.6, 0.0]#[0.0, 0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9]
Ensemble_index = 5

print('Target domain')
for i in range(len(tau)):
	print(-(i+1), tau[-(i+1)])
	print('tau={}: used_feature={:.2f}, test_ave={:.2f}, test_SE={:.2f}'.format(tau[-(i+1)], data['T'][...,-(i+1)].mean(), data['T'][...,-(i+1)].mean()*100,data['T'][...,-(i+1)].std()/ np.sqrt(n)*100))
print('Ensemble: used_feature={:.2f}, test_ave={:.2f}, test_SE={:.2f}'.format(data['T'][...,-Ensemble_index].mean(), data['T'][...,-Ensemble_index].mean()*100, data['T'][...,-Ensemble_index].std()/ np.sqrt(n)*100))

# print('Source domains')
# for i in range(len(tau)):

# 	print('tau={}: used_feature={:.2f}, val_ave={:.2f}, val_SE={:.2f}'.format(tau[-(i+1)], data['X'][...,-(i+1)].mean(), data['V'][...,-(i+1)].mean()*100,data['V'][...,-(i+1)].std()/ np.sqrt(n)*100))
# print('Ensemble: used_feature={:.2f}, val_ave={:.2f}, val_SE={:.2f}'.format(data['X'][...,-Ensemble_index].mean(), data['V'][...,-Ensemble_index].mean()*100, data['V'][...,-Ensemble_index].std()/ np.sqrt(n)*100))



