from torch import optim


def get_optim_and_scheduler(network, epochs, lr):
	optimizer = optim.SGD(network, weight_decay=.0005, momentum=.9, nesterov=False, lr=lr)
	step_size = int(epochs * .8)
	scheduler = optim.lr_scheduler.StepLR(optimizer, step_size=step_size)
	return optimizer, scheduler

# def get_optim_and_scheduler(network, epochs, lr):
#     adam_optimizer = optim.Adam(network, weight_decay=.0, lr=lr)

#     optimizer = optim.SGD(network, weight_decay=.0005, momentum=.9, nesterov=False, lr=lr)
#     step_size = int(epochs * .8)
#     scheduler = optim.lr_scheduler.StepLR(optimizer, step_size=step_size)
#     return adam_optimizer, scheduler