#LASSO
### Datasets
Download dataset and move them to folder **LASSO/data/**.

- **VLCS**: https://drive.google.com/uc?id=1skwblH1_okBwxWxmRsp9_qi15hyPpxg8
	- For this dataset, please move it to folder  **LASSO/data/VLCS/**
	
- **PACS**: https://drive.google.com/u/0/uc?export=download&confirm=Asc4&id=0B6x7gtvErXgfbF9CSk53UkRxVzg
	- For this dataset, please move it to folder  **LASSO/data/pacs/**
	- and move domains to folder **LASSO/data/pacs/images**
	
- **OfficeHome**: https://drive.google.com/uc?id=0B81rNlvomiwed0V1YUxQdC1uOTg
	- For this dataset, please move it to folder  **LASSO/data/OfficeHome/**
	- and change the domain name "Real World" to "RealWorld"
	
### Available backbones:
Download the backbones and move them to folder  **LASSO/models/pretrained_models/**.

- ResNet18: https://download.pytorch.org/models/resnet18-5c106cde.pth
- ResNet50: https://download.pytorch.org/models/resnet50-19c8e357.pth
- Alexnet: https://drive.google.com/file/d/1wUJTH1Joq2KAgrUDeKJghP1Wf7Q9w4z-/view

### Running experiments:
Due to the differences in inplementation of "sub-space indicator" between ResNet and other backbones, we provide examples on how to get Backbones (ReNet18, ReNet50, Alexnet) results on different datasets (PACS, OfficeHome, VLCS) in folder *LASSO/examples/*.

- Go to  **LASSO/examples/** and run:

```
python PACS_resnet.py --target art_painting --network ResNet50 --runs 5
```
```
python OfficeHome_resnet.py --target Product --network ResNet50
```
```
python VLCS_alexnet.py --target CALTECH
```
```
python PACS_alexnet.py --target art_painting
```

Note:
```
--network ResNet50 #  backbone
--target art_painting # target domain
--runs 5 # running experiments multiple (5) times
```

##### Results:
Results are stored in folder *LASSO/examples/result*
results includes the following values for each training epoch:
- validation accuracy
- validation used features
- test accuracy
- test used features

Example of reading results (result of last epoch):

```
python read_results --name sketch_resnet18.npz
```

