import sys
sys.path.append('../')
import argparse
import torch
from torch import nn
import numpy as np
import random
import os
from arguments import args, parse_args
from trainer_alexnet import Trainer
from utils.utils import seed_libraries

def main():
	
	args.dataset = 'VLCS'
	args.source = ["CALTECH", "LABELME", "PASCAL", "SUN"]
	args.source.remove(args.target)
	print("Source domain: {}".format(args.source))
	print("Target domain: {}".format(args.target))
	
	args.n_classes = 5
	args.epochs = 50
	args.batch_size = 64
	args.learning_rate = 0.001
	args.mask_learning_rate = 0.01
	args.feature_dim = 4096
	args.sigmoid_head = True
	args.partition = 128 # or 256
	args.drop_rate = 0.15
	args.network == 'Alexnet'
	#args.tau = [-1.0, 0.0, 0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9] #-1.0 is euqal to Ensemble
	args.tau = [-1.0,  0.4, 0.5, 0.6, 0.7]

	device = torch.device("cuda" if torch.cuda.is_available() else "cpu")
	
	val_results = []
	test_results = []
	test_used_features = []
	val_used_features = []
	for run in range(args.runs):
		trainer = Trainer(args, device)
		results, utilized_features = trainer.do_training()
		val_results.append(results['val'])
		test_results.append(results['test'])
		test_used_features.append(utilized_features['val'])
		val_used_features.append(utilized_features['test'])
		np.savez('results/{}_{}.npz'.format(args.target, args.network),  
			V=np.array(val_results), 
			T=np.array(test_results),
			X=np.array(val_used_features), 
			Y=np.array(test_used_features))
		print(args)


if __name__ == "__main__":
	parse_args(args)
	torch.backends.cudnn.benchmark = True
	main()


