# 'Explaining RL Decisions with Trajectories': A Reproducibility Study

This repository contains the codebase for our reproducibility study on "Explaining RL Decisions with Trajectories." Our work is conducted in the context of the Fairness, Accountability, Confidentiality, and Transparency in AI course offered by the University of Amsterdam.

## Paper Links

- Our paper: ['Explaining RL Decisions with Trajectories': A Reproducibility Study](https://openreview.net/forum?id=QdeBbK5CSh&referrer=%5Bthe%20profile%20of%20Matteo%20Nulli%5D(%2Fprofile%3Fid%3D~Matteo_Nulli1))
- Original paper: [Explaining RL Decisions with Trajectories](https://arxiv.org/abs/2305.04073)

## Project Structure

The project is divided into two main parts, each contained in its own directory with dedicated `requirements.txt` files and `README` for setup instructions:

- **Grid-World Experiments:** Located in the `Grid-World` folder, this part includes all necessary code to replicate the gridworld experiments described in the original study and to perform additional experiments from our paper.
- **Seaquest and Half Cheetah Experiments:** The `Seaquest_HalfCheetah` folder contains code for replicating experiments on the Seaquest and Half Cheetah environments and to conduct the supplementary experiments described in our paper

## Getting Started

Please refer to the `README.md` file within each directory for detailed instructions on setting up and running the experiments.

## Contact Information

For any queries, suggestions, or discussions regarding the project, feel free to contact the authors:

- **Author 1**: Karim Abdel Sadek - karim.abdel.sadek@student.uva.nl
- **Author 2**: Matteo Nulli - matteo.nulli@student.uva.nl
- **Author 3**: Joan Velja - joan.velja@student.uva.nl
- **Author 3**: Jort Vincenti - jort.vincenti@student.uva.nl

Alternatively, you can raise an issue in this repository for any specific questions or suggestions related to the codebase.
