/*
 * struct Iterator;
 * struct Iterator {
 *     // Returns true if the iteration has more elements.
 *     bool (*hasNext)();
 *
 *     // Returns the next element in the iteration.
 *     int (*next)();
 * };
 */

struct PeekingIterator {
    struct Iterator* iterator;
    bool hasPeeked;
    int peekedElement;
};

struct PeekingIterator* Constructor(struct Iterator* iter) {
    struct PeekingIterator* piter = malloc(sizeof(struct PeekingIterator));
    piter->iterator = iter;
    piter->hasPeeked = false;
    piter->peekedElement = 0;
    return piter;
}

int peek(struct PeekingIterator* obj) {
    if (!obj->hasPeeked) {
        obj->peekedElement = obj->iterator->next();
        obj->hasPeeked = true;
    }
    return obj->peekedElement;
}

int next(struct PeekingIterator* obj) {
    if (!obj->hasPeeked) {
        return obj->iterator->next();
    }
    obj->hasPeeked = false;
    return obj->peekedElement;
}

bool hasNext(struct PeekingIterator* obj) {
    return obj->hasPeeked || obj->iterator->hasNext();
}

/**
 * Your PeekingIterator struct will be instantiated and called as such:
 * struct PeekingIterator* obj = peekingIteratorCreate(arr, arrSize);
 * int param_1 = peek(obj);
 * int param_2 = next(obj);
 * bool param_3 = hasNext(obj);
 * peekingIteratorFree(obj);
 */