int rows, cols;

bool dfs(char** board, char* word, int i, int j, int index) {
    if (index == strlen(word)) return true;
    if (i < 0 || i >= rows || j < 0 || j >= cols || board[i][j] != word[index]) return false;

    char temp = board[i][j];
    board[i][j] = '#';

    bool found = dfs(board, word, i+1, j, index+1) ||
                 dfs(board, word, i-1, j, index+1) ||
                 dfs(board, word, i, j+1, index+1) ||
                 dfs(board, word, i, j-1, index+1);

    board[i][j] = temp;
    return found;
}

bool exist(char** board, int boardSize, int* boardColSize, char* word) {
    rows = boardSize;
    cols = boardColSize[0];

    for (int i = 0; i < rows; i++) {
        for (int j = 0; j < cols; j++) {
            if (dfs(board, word, i, j, 0)) {
                return true;
            }
        }
    }
    return false;
}