int find(int* parent, int x) {
    if (parent[x] != x) {
        parent[x] = find(parent, parent[x]);
    }
    return parent[x];
}

void unionSets(int* parent, int* size, int x, int y) {
    int rootX = find(parent, x);
    int rootY = find(parent, y);
    if (rootX != rootY) {
        if (size[rootX] < size[rootY]) {
            parent[rootX] = rootY;
            size[rootY] += size[rootX];
        } else {
            parent[rootY] = rootX;
            size[rootX] += size[rootY];
        }
    }
}

int minMalwareSpread(int* graph, int graphSize, int* graphColSize, int* initial, int initialSize) {
    int n = graphSize;
    int parent[n];
    int size[n];

    for (int i = 0; i < n; i++) {
        parent[i] = i;
        size[i] = 1;
    }

    for (int i = 0; i < n; i++) {
        for (int j = i + 1; j < n; j++) {
            if (graph[i * n + j] == 1) {
                unionSets(parent, size, i, j);
            }
        }
    }

    int malwareCount[n];
    for (int i = 0; i < n; i++) {
        malwareCount[i] = 0;
    }

    for (int i = 0; i < initialSize; i++) {
        int root = find(parent, initial[i]);
        malwareCount[root]++;
    }

    int result = -1;
    int maxSize = -1;

    for (int i = 0; i < initialSize; i++) {
        int node = initial[i];
        int root = find(parent, node);
        if (malwareCount[root] == 1) {
            if (size[root] > maxSize) {
                maxSize = size[root];
                result = node;
            } else if (size[root] == maxSize && node < result) {
                result = node;
            }
        }
    }

    if (result == -1) {
        result = initial[0];
        for (int i = 1; i < initialSize; i++) {
            if (initial[i] < result) {
                result = initial[i];
            }
        }
    }

    return result;
}