int minMalwareSpread(int** graph, int graphSize, int* graphColSize, int* initial, int initialSize) {
    int* infectedBy = (int*)malloc(graphSize * sizeof(int));
    for (int i = 0; i < graphSize; i++) {
        infectedBy[i] = -1;
    }

    int* clean = (int*)malloc(graphSize * sizeof(int));
    for (int i = 0; i < graphSize; i++) {
        clean[i] = 1;
    }
    for (int i = 0; i < initialSize; i++) {
        clean[initial[i]] = 0;
    }

    for (int i = 0; i < initialSize; i++) {
        int* queue = (int*)malloc(graphSize * sizeof(int));
        int front = 0, rear = 0;
        int* visited = (int*)calloc(graphSize, sizeof(int));

        queue[rear++] = initial[i];
        visited[initial[i]] = 1;

        while (front < rear) {
            int node = queue[front++];
            for (int j = 0; j < graphSize; j++) {
                if (graph[node][j] == 1 && clean[j] == 1 && !visited[j]) {
                    visited[j] = 1;
                    if (infectedBy[j] == -1) {
                        infectedBy[j] = initial[i];
                    } else if (infectedBy[j] != -2) {
                        infectedBy[j] = -2;
                    }
                    queue[rear++] = j;
                }
            }
        }

        free(queue);
        free(visited);
    }

    int* saveCount = (int*)calloc(graphSize, sizeof(int));
    for (int i = 0; i < graphSize; i++) {
        if (infectedBy[i] >= 0) {
            saveCount[infectedBy[i]]++;
        }
    }

    int result = -1;
    int maxSave = -1;
    for (int i = 0; i < initialSize; i++) {
        int node = initial[i];
        if (saveCount[node] > maxSave) {
            maxSave = saveCount[node];
            result = node;
        } else if (saveCount[node] == maxSave && node < result) {
            result = node;
        }
    }

    if (result == -1) {
        int minNode = graphSize;
        for (int i = 0; i < initialSize; i++) {
            if (initial[i] < minNode) {
                minNode = initial[i];
            }
        }
        result = minNode;
    }

    free(infectedBy);
    free(clean);
    free(saveCount);

    return result;
}