
using namespace std;

class Solution {
public:
    int shipWithinDays(vector<int>& weights, int days) {
        int left = *max_element(weights.begin(), weights.end());
        int right = accumulate(weights.begin(), weights.end(), 0);

        while (left < right) {
            int mid = left + (right - left) / 2;
            if (canShip(weights, days, mid)) {
                right = mid;
            } else {
                left = mid + 1;
            }
        }
        return left;
    }

private:
    bool canShip(vector<int>& weights, int days, int capacity) {
        int current = 0;
        int requiredDays = 1;

        for (int weight : weights) {
            if (current + weight > capacity) {
                requiredDays++;
                current = 0;
            }
            current += weight;
        }

        return requiredDays <= days;
    }
};