class UnionFind {
private:
    vector<int> parent;
    vector<int> size;
public:
    UnionFind(int n) {
        parent.resize(n);
        size.resize(n, 1);
        for (int i = 0; i < n; ++i) {
            parent[i] = i;
        }
    }

    int find(int x) {
        if (parent[x] != x) {
            parent[x] = find(parent[x]);
        }
        return parent[x];
    }

    void unite(int x, int y) {
        int rootX = find(x);
        int rootY = find(y);
        if (rootX != rootY) {
            if (size[rootX] < size[rootY]) {
                swap(rootX, rootY);
            }
            parent[rootY] = rootX;
            size[rootX] += size[rootY];
        }
    }

    int getSize(int x) {
        return size[find(x)];
    }
};

class Solution {
public:
    int minMalwareSpread(vector<vector<int>>& graph, vector<int>& initial) {
        int n = graph.size();
        UnionFind uf(n);
        for (int i = 0; i < n; ++i) {
            for (int j = i + 1; j < n; ++j) {
                if (graph[i][j] == 1) {
                    uf.unite(i, j);
                }
            }
        }

        vector<int> count(n, 0);
        for (int node : initial) {
            count[uf.find(node)]++;
        }

        int result = -1;
        int maxSize = -1;
        sort(initial.begin(), initial.end());
        for (int node : initial) {
            int root = uf.find(node);
            if (count[root] == 1) {
                if (uf.getSize(root) > maxSize) {
                    maxSize = uf.getSize(root);
                    result = node;
                }
            }
        }

        return result == -1 ? initial[0] : result;
    }
};