class Solution {
public:
    int minMalwareSpread(vector<vector<int>>& graph, vector<int>& initial) {
        int n = graph.size();
        sort(initial.begin(), initial.end());
        int min_node = initial[0];
        int min_infected = n;

        for (int node_to_remove : initial) {
            unordered_set<int> infected(initial.begin(), initial.end());
            infected.erase(node_to_remove);
            queue<int> q;
            for (int infected_node : infected) {
                q.push(infected_node);
            }

            while (!q.empty()) {
                int current = q.front();
                q.pop();
                for (int neighbor = 0; neighbor < n; ++neighbor) {
                    if (graph[current][neighbor] == 1 && infected.count(neighbor) == 0) {
                        infected.insert(neighbor);
                        q.push(neighbor);
                    }
                }
            }

            if (infected.size() < min_infected) {
                min_infected = infected.size();
                min_node = node_to_remove;
            }
        }

        return min_node;
    }
};