class Solution {
public:
    bool isCousins(TreeNode* root, int x, int y) {
        if (!root) return false;

        queue<TreeNode*> q;
        q.push(root);

        while (!q.empty()) {
            int size = q.size();
            bool foundX = false, foundY = false;

            for (int i = 0; i < size; ++i) {
                TreeNode* node = q.front();
                q.pop();

                if (node->val == x) foundX = true;
                if (node->val == y) foundY = true;

                if (node->left && node->right) {
                    if ((node->left->val == x && node->right->val == y) || 
                        (node->left->val == y && node->right->val == x)) {
                        return false;
                    }
                }

                if (node->left) q.push(node->left);
                if (node->right) q.push(node->right);
            }

            if (foundX && foundY) return true;
            if (foundX || foundY) return false;
        }

        return false;
    }
};