-spec min_malware_spread(Graph :: [[integer()]], Initial :: [integer()]) -> integer().
min_malware_spread(Graph, Initial) ->
    N = length(Graph),
    Parents = lists:seq(0, N - 1),
    InitialSorted = lists:sort(Initial),

    UnionFind = union_find(Graph, Parents),
    Size = count_sizes(UnionFind, N),

    Count = count_infected(UnionFind, InitialSorted, N),

    {Result, _} = lists:foldl(
        fun(Node, {Ans, MaxSize}) ->
            Root = find(UnionFind, Node),
            case lists:nth(Root + 1, Count) of
                1 ->
                    CurrentSize = lists:nth(Root + 1, Size),
                    if
                        CurrentSize > MaxSize ->
                            {Node, CurrentSize};
                        CurrentSize == MaxSize andalso Node < Ans ->
                            {Node, MaxSize};
                        true ->
                            {Ans, MaxSize}
                    end;
                _ ->
                    {Ans, MaxSize}
            end
        end,
        {hd(InitialSorted), -1},
        InitialSorted
    ),
    Result.

union_find(Graph, Parents) ->
    lists:foldl(
        fun(I, Acc) ->
            lists:foldl(
                fun(J, Acc1) ->
                    case lists:nth(J + 1, lists:nth(I + 1, Graph)) of
                        1 ->
                            union(Acc1, I, J);
                        _ ->
                            Acc1
                    end
                end,
                Acc,
                lists:seq(0, length(Graph) - 1)
            )
        end,
        Parents,
        lists:seq(0, length(Graph) - 1)
    ).

find(Parents, X) ->
    case lists:nth(X + 1, Parents) of
        X ->
            X;
        P ->
            NewParent = find(Parents, P),
            Parents1 = setelement(X + 1, list_to_tuple(Parents), NewParent),
            NewParent
    end.

union(Parents, X, Y) ->
    XRoot = find(Parents, X),
    YRoot = find(Parents, Y),
    if
        XRoot == YRoot ->
            Parents;
        true ->
            setelement(XRoot + 1, list_to_tuple(Parents), YRoot)
    end.

count_sizes(Parents, N) ->
    lists:foldl(
        fun(I, Acc) ->
            Root = find(Parents, I),
            Current = lists:nth(Root + 1, Acc),
            setelement(Root + 1, list_to_tuple(Acc), Current + 1)
        end,
        lists:duplicate(N, 0),
        lists:seq(0, N - 1)
    ).

count_infected(Parents, Initial, N) ->
    lists:foldl(
        fun(Node, Acc) ->
            Root = find(Parents, Node),
            Current = lists:nth(Root + 1, Acc),
            setelement(Root + 1, list_to_tuple(Acc), Current + 1)
        end,
        lists:duplicate(N, 0),
        Initial
    ).