-module(solution).
-export([min_malware_spread/2]).

min_malware_spread(Graph, Initial) ->
    N = length(Graph),
    InitialSet = sets:from_list(Initial),
    lists:foldl(
        fun(Node, {MinInfected, Result}) ->
            case sets:is_element(Node, InitialSet) of
                true ->
                    Infected = count_infected(Graph, InitialSet, Node, N),
                    if
                        Infected > MinInfected -> {Infected, Node};
                        Infected == MinInfected andalso Node < Result -> {MinInfected, Node};
                        true -> {MinInfected, Result}
                    end;
                false -> {MinInfected, Result}
            end
        end,
        {-1, hd(Initial)},
        lists:seq(0, N - 1)
    ).

count_infected(Graph, InitialSet, Removed, N) ->
    Visited = sets:new(),
    Queue = lists:filter(
        fun(Node) ->
            Node =/= Removed andalso sets:is_element(Node, InitialSet)
        end,
        sets:to_list(InitialSet)
    ),
    count_infected_helper(Graph, InitialSet, Removed, Queue, Visited, N).

count_infected_helper(_Graph, _InitialSet, _Removed, [], Visited, _N) ->
    sets:size(Visited);
count_infected_helper(Graph, InitialSet, Removed, [Node | Rest], Visited, N) ->
    case sets:is_element(Node, Visited) of
        true ->
            count_infected_helper(Graph, InitialSet, Removed, Rest, Visited, N);
        false ->
            NewVisited = sets:add_element(Node, Visited),
            Neighbors = lists:filter(
                fun(Neighbor) ->
                    lists:nth(Node + 1, Graph) =/= 0 andalso
                    Neighbor =/= Removed andalso
                    not sets:is_element(Neighbor, NewVisited)
                end,
                lists:seq(0, N - 1)
            ),
            count_infected_helper(Graph, InitialSet, Removed, Rest ++ Neighbors, NewVisited, N)
    end.