func numPrimeArrangements(n int) int {
    const mod = 1e9 + 7
    primes := countPrimes(n + 1)
    return factorial(primes, mod) * factorial(n - primes, mod) % mod
}

func countPrimes(n int) int {
    if n <= 2 {
        return 0
    }
    isPrime := make([]bool, n)
    for i := 2; i < n; i++ {
        isPrime[i] = true
    }
    for i := 2; i*i < n; i++ {
        if isPrime[i] {
            for j := i * i; j < n; j += i {
                isPrime[j] = false
            }
        }
    }
    count := 0
    for i := 2; i < n; i++ {
        if isPrime[i] {
            count++
        }
    }
    return count
}

func factorial(n, mod int) int {
    res := 1
    for i := 2; i <= n; i++ {
        res = res * i % mod
    }
    return res
}