import (
	"container/heap"
)

type IntHeap []int

func (h IntHeap) Len() int           { return len(h) }
func (h IntHeap) Less(i, j int) bool { return h[i] < h[j] }
func (h IntHeap) Swap(i, j int)      { h[i], h[j] = h[j], h[i] }

func (h *IntHeap) Push(x interface{}) {
	*h = append(*h, x.(int))
}

func (h *IntHeap) Pop() interface{} {
	old := *h
	n := len(old)
	x := old[n-1]
	*h = old[0 : n-1]
	return x
}

func minOperations(nums []int, k int) int {
	h := &IntHeap{}
	heap.Init(h)
	for _, num := range nums {
		heap.Push(h, num)
	}

	operations := 0
	for (*h)[0] < k && h.Len() >= 2 {
		x := heap.Pop(h).(int)
		y := heap.Pop(h).(int)
		newNum := x*2 + y
		heap.Push(h, newNum)
		operations++
	}

	if (*h)[0] < k {
		return -1
	}
	return operations
}