func champagneTower(poured int, query_row int, query_glass int) float64 {
    tower := make([][]float64, query_row+1)
    for i := range tower {
        tower[i] = make([]float64, i+1)
    }
    tower[0][0] = float64(poured)

    for i := 0; i < query_row; i++ {
        for j := 0; j <= i; j++ {
            excess := (tower[i][j] - 1.0) / 2.0
            if excess > 0 {
                tower[i+1][j] += excess
                tower[i+1][j+1] += excess
            }
        }
    }

    if tower[query_row][query_glass] > 1.0 {
        return 1.0
    }
    return tower[query_row][query_glass]
}