func minMalwareSpread(graph [][]int, initial []int) int {
    n := len(graph)
    parent := make([]int, n)
    size := make([]int, n)
    for i := range parent {
        parent[i] = i
        size[i] = 1
    }

    var find func(int) int
    find = func(u int) int {
        if parent[u] != u {
            parent[u] = find(parent[u])
        }
        return parent[u]
    }

    union := func(u, v int) {
        pu, pv := find(u), find(v)
        if pu != pv {
            if size[pu] < size[pv] {
                pu, pv = pv, pu
            }
            parent[pv] = pu
            size[pu] += size[pv]
        }
    }

    for i := 0; i < n; i++ {
        for j := i + 1; j < n; j++ {
            if graph[i][j] == 1 {
                union(i, j)
            }
        }
    }

    infected := make(map[int]int)
    for _, node := range initial {
        p := find(node)
        infected[p]++
    }

    maxSize, res := -1, -1
    for _, node := range initial {
        p := find(node)
        if infected[p] == 1 {
            if size[p] > maxSize {
                maxSize = size[p]
                res = node
            } else if size[p] == maxSize && node < res {
                res = node
            }
        }
    }

    if res == -1 {
        res = initial[0]
        for _, node := range initial {
            if node < res {
                res = node
            }
        }
    }

    return res
}