func minMalwareSpread(graph [][]int, initial []int) int {
    n := len(graph)
    sort.Ints(initial)
    minNode := initial[0]
    maxSaved := -1

    for _, removed := range initial {
        infected := make(map[int]bool)
        for _, node := range initial {
            if node != removed {
                infected[node] = true
            }
        }

        queue := make([]int, 0)
        for node := range infected {
            queue = append(queue, node)
        }

        for len(queue) > 0 {
            current := queue[0]
            queue = queue[1:]
            for neighbor := 0; neighbor < n; neighbor++ {
                if graph[current][neighbor] == 1 && !infected[neighbor] {
                    infected[neighbor] = true
                    queue = append(queue, neighbor)
                }
            }
        }

        saved := 0
        for i := 0; i < n; i++ {
            if !infected[i] {
                saved++
            }
        }

        if saved > maxSaved || (saved == maxSaved && removed < minNode) {
            maxSaved = saved
            minNode = removed
        }
    }

    return minNode
}