/**
 * Definition for a binary tree node.
 * type TreeNode struct {
 *     Val int
 *     Left *TreeNode
 *     Right *TreeNode
 * }
 */
func generateTrees(n int) []*TreeNode {
    if n == 0 {
        return nil
    }
    return generate(1, n)
}

func generate(start, end int) []*TreeNode {
    trees := []*TreeNode{}
    if start > end {
        trees = append(trees, nil)
        return trees
    }
    for i := start; i <= end; i++ {
        leftTrees := generate(start, i-1)
        rightTrees := generate(i+1, end)
        for _, left := range leftTrees {
            for _, right := range rightTrees {
                root := &TreeNode{Val: i}
                root.Left = left
                root.Right = right
                trees = append(trees, root)
            }
        }
    }
    return trees
}