class Solution {
    private int maxSum = 0;

    public int maxSumBST(TreeNode root) {
        traverse(root);
        return maxSum;
    }

    private int[] traverse(TreeNode root) {
        if (root == null) {
            return new int[]{Integer.MAX_VALUE, Integer.MIN_VALUE, 0};
        }

        int[] left = traverse(root.left);
        int[] right = traverse(root.right);

        if (left == null || right == null || root.val <= left[1] || root.val >= right[0]) {
            return null;
        }

        int sum = root.val + left[2] + right[2];
        maxSum = Math.max(maxSum, sum);

        int min = Math.min(root.val, left[0]);
        int max = Math.max(root.val, right[1]);

        return new int[]{min, max, sum};
    }
}