class Solution {
    public int ways(String[] pizza, int k) {
        int rows = pizza.length;
        int cols = pizza[0].length();
        int[][] apples = new int[rows + 1][cols + 1];
        int[][][] dp = new int[k][rows][cols];

        for (int row = rows - 1; row >= 0; row--) {
            for (int col = cols - 1; col >= 0; col--) {
                apples[row][col] = (pizza[row].charAt(col) == 'A' ? 1 : 0) + apples[row + 1][col] + apples[row][col + 1] - apples[row + 1][col + 1];
                if (apples[row][col] > 0) {
                    dp[0][row][col] = 1;
                }
            }
        }

        for (int remain = 1; remain < k; remain++) {
            for (int row = 0; row < rows; row++) {
                for (int col = 0; col < cols; col++) {
                    for (int next_row = row + 1; next_row < rows; next_row++) {
                        if (apples[row][col] - apples[next_row][col] > 0) {
                            dp[remain][row][col] += dp[remain - 1][next_row][col];
                            dp[remain][row][col] %= 1_000_000_007;
                        }
                    }
                    for (int next_col = col + 1; next_col < cols; next_col++) {
                        if (apples[row][col] - apples[row][next_col] > 0) {
                            dp[remain][row][col] += dp[remain - 1][row][next_col];
                            dp[remain][row][col] %= 1_000_000_007;
                        }
                    }
                }
            }
        }

        return dp[k - 1][0][0];
    }
}