class Solution {
    public int countPalindromicSubsequences(String S) {
        int n = S.length();
        int MOD = 1000000007;
        int[][] dp = new int[n][n];

        for (int i = 0; i < n; i++) {
            dp[i][i] = 1;
        }

        for (int len = 2; len <= n; len++) {
            for (int i = 0; i < n - len + 1; i++) {
                int j = i + len - 1;
                if (S.charAt(i) == S.charAt(j)) {
                    int left = i + 1;
                    int right = j - 1;
                    while (left <= right && S.charAt(left) != S.charAt(i)) {
                        left++;
                    }
                    while (left <= right && S.charAt(right) != S.charAt(i)) {
                        right--;
                    }
                    if (left > right) {
                        dp[i][j] = dp[i + 1][j - 1] * 2 + 2;
                    } else if (left == right) {
                        dp[i][j] = dp[i + 1][j - 1] * 2 + 1;
                    } else {
                        dp[i][j] = dp[i + 1][j - 1] * 2 - dp[left + 1][right - 1];
                    }
                } else {
                    dp[i][j] = dp[i][j - 1] + dp[i + 1][j] - dp[i + 1][j - 1];
                }
                dp[i][j] = dp[i][j] < 0 ? dp[i][j] + MOD : dp[i][j] % MOD;
            }
        }

        return dp[0][n - 1];
    }
}