class Solution {
    public int minMalwareSpread(int[][] graph, int[] initial) {
        int n = graph.length;
        UnionFind uf = new UnionFind(n);
        for (int i = 0; i < n; i++) {
            for (int j = i + 1; j < n; j++) {
                if (graph[i][j] == 1) {
                    uf.union(i, j);
                }
            }
        }
        int[] count = new int[n];
        for (int node : initial) {
            count[uf.find(node)]++;
        }
        Arrays.sort(initial);
        int result = initial[0];
        int maxSize = -1;
        for (int node : initial) {
            int root = uf.find(node);
            if (count[root] == 1) {
                int size = uf.size(root);
                if (size > maxSize) {
                    maxSize = size;
                    result = node;
                } else if (size == maxSize && node < result) {
                    result = node;
                }
            }
        }
        return result;
    }

    class UnionFind {
        private int[] parent;
        private int[] size;

        public UnionFind(int n) {
            parent = new int[n];
            size = new int[n];
            for (int i = 0; i < n; i++) {
                parent[i] = i;
                size[i] = 1;
            }
        }

        public int find(int x) {
            if (parent[x] != x) {
                parent[x] = find(parent[x]);
            }
            return parent[x];
        }

        public void union(int x, int y) {
            int rootX = find(x);
            int rootY = find(y);
            if (rootX != rootY) {
                if (size[rootX] < size[rootY]) {
                    parent[rootX] = rootY;
                    size[rootY] += size[rootX];
                } else {
                    parent[rootY] = rootX;
                    size[rootX] += size[rootY];
                }
            }
        }

        public int size(int x) {
            return size[find(x)];
        }
    }
}