class Solution {
    public int minMalwareSpread(int[][] graph, int[] initial) {
        int n = graph.length;
        Arrays.sort(initial);
        int minNode = initial[0];
        int minInfected = Integer.MAX_VALUE;

        for (int nodeToRemove : initial) {
            boolean[] infected = new boolean[n];
            for (int infectedNode : initial) {
                if (infectedNode != nodeToRemove) {
                    dfs(graph, infectedNode, infected, nodeToRemove);
                }
            }
            int totalInfected = 0;
            for (boolean isInfected : infected) {
                if (isInfected) {
                    totalInfected++;
                }
            }
            if (totalInfected < minInfected) {
                minInfected = totalInfected;
                minNode = nodeToRemove;
            }
        }

        return minNode;
    }

    private void dfs(int[][] graph, int node, boolean[] infected, int nodeToRemove) {
        if (infected[node] || node == nodeToRemove) {
            return;
        }
        infected[node] = true;
        for (int neighbor = 0; neighbor < graph.length; neighbor++) {
            if (graph[node][neighbor] == 1) {
                dfs(graph, neighbor, infected, nodeToRemove);
            }
        }
    }
}