var findMaxFish = function(grid) {
    const m = grid.length;
    const n = grid[0].length;
    let maxFish = 0;

    const dfs = (i, j) => {
        if (i < 0 || i >= m || j < 0 || j >= n || grid[i][j] === 0) {
            return 0;
        }
        const fish = grid[i][j];
        grid[i][j] = 0;
        return fish + dfs(i + 1, j) + dfs(i - 1, j) + dfs(i, j + 1) + dfs(i, j - 1);
    };

    for (let i = 0; i < m; i++) {
        for (let j = 0; j < n; j++) {
            if (grid[i][j] > 0) {
                const currentFish = dfs(i, j);
                maxFish = Math.max(maxFish, currentFish);
            }
        }
    }

    return maxFish;
};