var findMinDifference = function(timePoints) {
    const minutes = timePoints.map(time => {
        const [h, m] = time.split(':').map(Number);
        return h * 60 + m;
    }).sort((a, b) => a - b);

    let minDiff = Infinity;
    for (let i = 1; i < minutes.length; i++) {
        minDiff = Math.min(minDiff, minutes[i] - minutes[i - 1]);
    }

    const circularDiff = 1440 + minutes[0] - minutes[minutes.length - 1];
    return Math.min(minDiff, circularDiff);
};