var minMalwareSpread = function(graph, initial) {
    const n = graph.length;
    const parent = new Array(n).fill(-1);

    function find(u) {
        if (parent[u] === -1) return u;
        return find(parent[u]);
    }

    function union(u, v) {
        const rootU = find(u);
        const rootV = find(v);
        if (rootU !== rootV) {
            parent[rootV] = rootU;
        }
    }

    for (let i = 0; i < n; i++) {
        for (let j = i + 1; j < n; j++) {
            if (graph[i][j] === 1) {
                union(i, j);
            }
        }
    }

    const size = new Array(n).fill(0);
    for (let i = 0; i < n; i++) {
        size[find(i)]++;
    }

    const infected = new Array(n).fill(0);
    initial.sort((a, b) => a - b);
    for (const node of initial) {
        infected[find(node)]++;
    }

    let result = initial[0];
    let maxSaved = -1;

    for (const node of initial) {
        const root = find(node);
        if (infected[root] === 1) {
            if (size[root] > maxSaved) {
                maxSaved = size[root];
                result = node;
            } else if (size[root] === maxSaved && node < result) {
                result = node;
            }
        }
    }

    return result;
};