var minMalwareSpread = function(graph, initial) {
    initial.sort((a, b) => a - b);
    let minNode = initial[0];
    let minInfected = Infinity;
    const n = graph.length;

    for (const nodeToRemove of initial) {
        const infected = new Set(initial.filter(node => node !== nodeToRemove));
        const visited = new Set();
        let totalInfected = 0;

        for (const node of infected) {
            if (!visited.has(node)) {
                const stack = [node];
                visited.add(node);
                let componentSize = 0;
                let isComponentInfected = false;

                while (stack.length > 0) {
                    const current = stack.pop();
                    componentSize++;

                    for (let neighbor = 0; neighbor < n; neighbor++) {
                        if (graph[current][neighbor] === 1 && !visited.has(neighbor)) {
                            if (infected.has(neighbor)) {
                                isComponentInfected = true;
                            }
                            visited.add(neighbor);
                            stack.push(neighbor);
                        }
                    }
                }

                if (isComponentInfected) {
                    totalInfected += componentSize;
                }
            }
        }

        if (totalInfected < minInfected) {
            minInfected = totalInfected;
            minNode = nodeToRemove;
        } else if (totalInfected === minInfected && nodeToRemove < minNode) {
            minNode = nodeToRemove;
        }
    }

    return minNode;
};