class Solution:
    def minimumTotalDistance(self, robot: List[int], factory: List[List[int]]) -> int:
        robot.sort()
        factory.sort()
        m, n = len(robot), len(factory)

        dp = [[float('inf')] * (n + 1) for _ in range(m + 1)]
        dp[0][0] = 0

        for j in range(1, n + 1):
            pos, limit = factory[j - 1]
            dp[0][j] = 0

        for i in range(1, m + 1):
            for j in range(1, n + 1):
                pos, limit = factory[j - 1]
                cost = 0
                dp[i][j] = dp[i][j - 1]
                for k in range(1, min(limit, i) + 1):
                    cost += abs(robot[i - k] - pos)
                    if dp[i - k][j - 1] + cost < dp[i][j]:
                        dp[i][j] = dp[i - k][j - 1] + cost

        return dp[m][n]