class Solution:
    def minMalwareSpread(self, graph: List[List[int]], initial: List[int]) -> int:
        n = len(graph)
        parent = [i for i in range(n)]
        size = [1] * n

        def find(u):
            while parent[u] != u:
                parent[u] = parent[parent[u]]
                u = parent[u]
            return u

        def union(u, v):
            u_root = find(u)
            v_root = find(v)
            if u_root == v_root:
                return
            if size[u_root] < size[v_root]:
                parent[u_root] = v_root
                size[v_root] += size[u_root]
            else:
                parent[v_root] = u_root
                size[u_root] += size[v_root]

        for i in range(n):
            for j in range(i + 1, n):
                if graph[i][j] == 1:
                    union(i, j)

        count = collections.defaultdict(int)
        for node in initial:
            root = find(node)
            count[root] += 1

        max_size = -1
        result = min(initial)

        for node in initial:
            root = find(node)
            if count[root] == 1:
                if size[root] > max_size:
                    max_size = size[root]
                    result = node
                elif size[root] == max_size and node < result:
                    result = node

        return result