class Solution:
    def minMalwareSpread(self, graph: List[List[int]], initial: List[int]) -> int:
        n = len(graph)
        initial_set = set(initial)
        clean_nodes = [i for i in range(n) if i not in initial_set]

        parent = [i for i in range(n)]
        size = [1] * n

        def find(u):
            while parent[u] != u:
                parent[u] = parent[parent[u]]
                u = parent[u]
            return u

        def union(u, v):
            u_root = find(u)
            v_root = find(v)
            if u_root == v_root:
                return
            if size[u_root] < size[v_root]:
                parent[u_root] = v_root
                size[v_root] += size[u_root]
            else:
                parent[v_root] = u_root
                size[u_root] += size[v_root]

        for u in clean_nodes:
            for v in clean_nodes:
                if graph[u][v] == 1:
                    union(u, v)

        infected_count = defaultdict(lambda: defaultdict(int))
        node_to_component = {}

        for u in clean_nodes:
            node_to_component[u] = find(u)

        for u in initial:
            infected_components = set()
            for v in clean_nodes:
                if graph[u][v] == 1:
                    infected_components.add(node_to_component[v])
            for comp in infected_components:
                infected_count[comp][u] += 1

        save = [0] * n
        for comp in infected_count:
            infected_nodes = infected_count[comp]
            if len(infected_nodes) == 1:
                u = next(iter(infected_nodes))
                save[u] += size[comp]

        max_save = max(save)
        if max_save == 0:
            return min(initial)
        candidates = [u for u in range(n) if save[u] == max_save]
        return min(candidates)