(define/contract (num-pairs-divisible-by60 time)
  (-> (listof exact-integer?) exact-integer?)
  (define remainders (make-vector 60 0))
  (define count 0)
  (for ([t time])
    (define rem (modulo t 60))
    (define complement (modulo (- 60 rem) 60))
    (set! count (+ count (vector-ref remainders complement)))
    (vector-set! remainders rem (add1 (vector-ref remainders rem))))
  count)