(define/contract (min-score-triangulation values)
  (-> (listof exact-integer?) exact-integer?)
  (let ([n (length values)])
    (let ([dp (make-vector (* n n) 0)])
    (for ([k (in-range 2 n)])
      (for ([i (in-range 0 (- n k))])
        (let ([j (+ i k)])
          (vector-set! dp (+ i (* j n)) +inf.0)
          (for ([m (in-range (+ i 1) j)])
            (let ([cost (+ (vector-ref dp (+ i (* m n))) 
                           (vector-ref dp (+ m (* j n))) 
                           (* (list-ref values i) 
                              (list-ref values j) 
                              (list-ref values m))])])
              (when (< cost (vector-ref dp (+ i (* j n))))
                (vector-set! dp (+ i (* j n)) cost)))))))
    (vector-ref dp (- n 1)))))