(define (num-tile-possibilities tiles)
  (let ((count (make-hash)))
    (for ([c (in-string tiles)])
      (hash-update! count c add1 0))
    (let loop ([count count])
      (let ((res 0))
        (for ([(k v) (in-hash count)])
          (when (> v 0)
            (hash-set! count k (- v 1))
            (set! res (+ res 1 (loop count)))
            (hash-set! count k v)))
        res))))