(define (smallest-subsequence s)
  (let ((count (make-hash))
        (visited (make-hash))
        (stack '()))
    (for ([c s])
      (hash-update! count c add1 0))
    (for ([c s])
      (hash-update! count c (lambda (v) (- v 1)))
      (when (not (hash-ref visited c #f))
        (let loop ()
          (when (and (not (null? stack))
                     (char<? c (car stack))
                     (> (hash-ref count (car stack) 0) 0))
            (hash-set! visited (car stack) #f)
            (set! stack (cdr stack))
            (loop)))
        (hash-set! visited c #t)
        (set! stack (cons c stack)))
    (list->string (reverse stack))))