(define/contract (invalid-transactions transactions)
  (-> (listof string?) (listof string?))
  (define transactions-list
    (for/list ([t transactions])
      (match (string-split t ",")
        [(list name time amount city)
         (list name (string->number time) (string->number amount) city)])))
  (define invalid '())
  (for ([i (in-range (length transactions-list))])
    (define current (list-ref transactions-list i))
    (define name (first current))
    (define time (second current))
    (define amount (third current))
    (define city (fourth current))
    (define invalid? #f)
    (when (> amount 1000)
      (set! invalid? #t))
    (for ([j (in-range (length transactions-list))]
          #:unless (= i j))
      (define other (list-ref transactions-list j))
      (define other-name (first other))
      (define other-time (second other))
      (define other-city (fourth other))
      (when (and (equal? name other-name)
                 (not (equal? city other-city))
                 (<= (abs (- time other-time)) 60))
        (set! invalid? #t)))
    (when invalid?
      (set! invalid (cons (list-ref transactions i) invalid))))
  (reverse invalid))