(define/contract (can-make-pali-queries s queries)
  (-> string? (listof (listof exact-integer?)) (listof boolean?))
  (let* ((n (string-length s))
         (prefix (make-vector (add1 n) (make-vector 26 0))))
    (for ([i (in-range n)])
      (for ([j (in-range 26)])
        (vector-set! (vector-ref prefix (add1 i)) j
                     (vector-ref (vector-ref prefix i) j)))
      (let ((c (char->integer (string-ref s i))))
        (vector-set! (vector-ref prefix (add1 i)) (- c 97)
                     (add1 (vector-ref (vector-ref prefix (add1 i)) (- c 97))))))
    (for/list ([q queries])
      (let* ((left (first q))
             (right (second q))
             (k (third q))
             (count 0))
        (for ([j (in-range 26)])
          (let ((diff (- (vector-ref (vector-ref prefix (add1 right)) j)
                         (vector-ref (vector-ref prefix left) j))))
            (when (odd? diff)
              (set! count (add1 count)))))
        (<= (quotient count 2) k))))