(define (find-num-of-valid-words words puzzles)
  (define (word->mask word)
    (for/fold ([mask 0])
              ([c (in-string word)])
      (bitwise-ior mask (arithmetic-shift 1 (- (char->integer c) 97)))))

  (define word-masks (make-hash))
  (for ([word (in-list words)])
    (define mask (word->mask word))
    (hash-update! word-masks mask add1 0))

  (define (count-valid puzzle)
    (define first-char (arithmetic-shift 1 (- (char->integer (string-ref puzzle 0)) 97)))
    (define puzzle-mask (word->mask puzzle))
    (define subset puzzle-mask)
    (define count 0)
    (let loop ()
      (when (not (zero? subset))
        (when (not (zero? (bitwise-and subset first-char)))
          (set! count (+ count (hash-ref word-masks subset 0))))
        (set! subset (bitwise-and (sub1 subset) puzzle-mask))
        (loop)))
    count)

  (for/list ([puzzle (in-list puzzles)])
    (count-valid puzzle)))