(define/contract (nth-ugly-number n a b c)
  (-> exact-integer? exact-integer? exact-integer? exact-integer? exact-integer?)
  (define (gcd x y)
    (if (zero? y) x (gcd y (remainder x y))))
  (define (lcm x y)
    (quotient (* x y) (gcd x y)))
  (define (count-ugly x)
    (+ (quotient x a) (quotient x b) (quotient x c)
       (- (quotient x (lcm a b)))
       (- (quotient x (lcm b c)))
       (- (quotient x (lcm a c)))
       (quotient x (lcm a (lcm b c)))))
  (let loop ([low 1] [high (* 2 (expt 10 9))])
    (if (>= low high)
        low
        (let ([mid (quotient (+ low high) 2)])
          (if (>= (count-ugly mid) n)
              (loop low mid)
              (loop (+ mid 1) high))))))